#pragma once

#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include <fstream.>
#include "tools.h"
#include "contentlist.h"

class CScnOptions : CXuiSceneImpl
{
public:
		
    XUI_IMPLEMENT_CLASS( CScnOptions, L"ScnOptions", XUI_CLASS_TABSCENE )

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
	XUI_END_MSG_MAP()

	//LIST_DATA m_ListData;
	    
	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );
};

class CScnOptionsMainScreen : CXuiSceneImpl
{
public:

	CXuiList m_DateFormat;
	CXuiList m_TimeFormat;
	CXuiCheckbox m_TempStatus;
	CXuiCheckbox m_Cels;
	CXuiCheckbox m_DiskStatus;
	CXuiCheckbox m_DisplayIP;
	CXuiCheckbox m_ShowStatus;
	CXuiCheckbox m_NTP;
	CXuiControl m_NTPSync;
	
    XUI_IMPLEMENT_CLASS( CScnOptionsMainScreen, L"ScnOptionsMainScreen", XUI_CLASS_SCENE )

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
		XUI_ON_XM_TIMER( OnTimer )
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
	XUI_END_MSG_MAP()

	//LIST_DATA m_ListData;
	    
	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
	HRESULT OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled );
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );

	void UpdateDateTimes();
};

class CScnOptionsGameList : CXuiSceneImpl
{
public:

	CXuiControl m_Reset;
	CXuiCheckbox m_UseBackgrounds;
	CXuiCheckbox m_UsePreviews;
	CXuiCheckbox m_PCEnabled;
	CXuiCheckbox m_SemiTransparent;

	
    XUI_IMPLEMENT_CLASS( CScnOptionsGameList, L"ScnOptionsGameList", XUI_CLASS_SCENE )

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
	XUI_END_MSG_MAP()

	//LIST_DATA m_ListData;
	    
	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );

};

class CScnOptionsSystemSettings : CXuiSceneImpl
{
public:
	CXuiSlider m_HorizO;
	CXuiSlider m_VertO;
	CXuiSlider m_FanSpeed;
	CXuiTextElement m_FanSpeedText;
	CXuiList m_PlayerLedType;

	wstring SpeedText;

	
    XUI_IMPLEMENT_CLASS( CScnOptionsSystemSettings, L"ScnOptionsSystemSettings", XUI_CLASS_SCENE )

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
		XUI_ON_XM_TIMER( OnTimer )
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
	XUI_END_MSG_MAP()

	//LIST_DATA m_ListData;
	    
	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
	HRESULT OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled );
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );
};

class CScnOptionsChooseSkin : CXuiSceneImpl
{
public:
	
	CXuiList m_Skin;
	CXuiControl m_Reload;

	map<int,wstring> Skins;
	
    XUI_IMPLEMENT_CLASS( CScnOptionsChooseSkin, L"ScnOptionsChooseSkin", XUI_CLASS_TABSCENE )

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
	XUI_END_MSG_MAP()

	//LIST_DATA m_ListData;
	    
	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );

	void LoadSkinList();
};

